<?php
/*--------------------------------------------------------------
   GetWidget.php 2021-07-12
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Action;

use Exception;
use Gambio\Admin\Modules\Statistics\Services\StatisticsOverviewService;
use Gambio\Core\Application\Http\Request;
use Gambio\Core\Application\Http\Response;
use Gambio\Core\Application\ValueObjects\UserPreferences;
use Gambio\Core\Language\App\LanguageService;

/**
 * @codeCoverageIgnore
 */
class GetWidget extends GetWidgetAction
{
    /**
     * @var StatisticsOverviewService
     */
    private $service;
    
    
    /**
     * Constructor.
     */
    public function __construct(
        StatisticsOverviewService $service,
        LanguageService $languageService,
        UserPreferences $userPreferences
    ) {
        $this->service = $service;
        parent::__construct($languageService, $userPreferences);
    }
    
    
    /**
     * @inheritDoc
     */
    public function handle(Request $request, Response $response): Response
    {
        try {
            $widget = $this->service->getWidgetById((int)$request->getAttribute('id'));
            
            return $response->withJson([
                                           'id'                 => $widget->id()->value(),
                                           'label'              => $widget->label()->value(),
                                           'icon'               => $widget->icon()->value(),
                                           'width'              => $widget->width()->value(),
                                           'height'             => $widget->height()->value(),
                                           'horizontalPosition' => $widget->horizontalPosition()->value(),
                                           'verticalPosition'   => $widget->verticalPosition()->value(),
                                           'visualization'      => $widget->visualization()->value(),
                                           'data'               => $this->mapDataToArray($widget->data()),
                                           'options'            => (object)$this->mapOptionsToArray($widget->options()),
                                       ]);
        } catch (Exception $exception) {
            return $response->withStatus(400)->withJson($exception->getMessage());
        }
    }
}